cd "C:\Users\GradQuant\Downloads"

import delimited "projectdata.csv"

summarize

summarize, detail

rename banfaninc treatment

// label define is the command
// party_codes is the name I wanted (this can be whatever you like)
// then you assign the values to a definition
label define party_control 0 "Republican" 1 "Democrat" .5 "Split"

//this does not work



tab sen_cont_alt

// note the use of the double equal "==" in the parentheses
replace sen_cont_alt = 3 if (sen_cont_alt == .5)

replace hs_cont_alt = 3 if (hs_cont_alt == .5)

// define and label these variables
label define party_control 0 "Republican" 1 "Democrat" 3 "Split"
// label values is the command
// this is followed by the variable to label and then what labels to use
label values sen_cont_alt party_control
label values hs_cont_alt party_control

tab hs_cont_alt

// tab is the command to tabulate followed by the variable you want to tabulate
// then enter a comma and specify the option generate to create dummy variables
// from the original variable and enter the name you want - I'll call it test
tab hs_cont_alt, generate(test)

rename test1 house_rep_control
rename test2 house_dem_control
rename test3 house_split_control

tab sen_cont_alt, generate(test)
rename test1 senate_rep_control
rename test2 senate_dem_control
rename test3 senate_split_control

drop if missing(treatment)
drop if missing(healthspendpc)

label variable year "Year"
label variable state "State"
label variable treatment "Did state adopt a ban on financial incentives for doctors to perform less costly"
label variable healthspendpc "Health care spending per capita"

summarize

//outreg2 (SSC) is user-written and must be installed before you can use it
ssc inst outreg2

// create a table of summary statistics
outreg2 using sumstats.doc, replace sum(log)

// summary statistics by treatment and control group
bysort treatment: summarize

bysort treatment: outreg2 using stats_by_group.doc, replace sum(log)

histogram treatment

histogram healthspendpc

scatter healthspendpc treatment

//negative values are impossible, transform our outcome variable using the log function.
gen log_healthspendpc = log(healthspendpc)

reg log_healthspendpc i.treatment

// create a table of results
outreg2 using regresults.doc, replace

reg log_healthspendpc i.treatment senate_dem_control house_dem_control hou_chamber sen_chamber

// append these results to previous table
outreg2 using regresults.doc, append

// this calculates the predicted values for the control and treatment
margins treatment, atmeans

marginsplot









